package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.EmpresaServicioPrevencion;
import com.ejie.ab04b.service.EmpresaServicioPrevencionService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0480s00Controller generated by UDA, 29-may-2017 9:13:29.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/empresaservicioprevencion")
public class EmpresaServicioPrevencionController {

	private static final Logger logger = LoggerFactory
			.getLogger(EmpresaServicioPrevencionController.class);

	@Autowired()
	private EmpresaServicioPrevencionService empresaServicioPrevencionService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  codprev080
	 *            String
	 *
	 * @param codprev080 the codprev 080
	 *  EmpresaServicioPrevencion Objeto correspondiente al identificador
	 *         indicado.
	 * @return the empresa servicio prevencion
	 */
	@RequestMapping(value = "/{codprev080}", method = RequestMethod.GET)
	public @ResponseBody EmpresaServicioPrevencion get(
			@PathVariable String codprev080) {
		EmpresaServicioPrevencion empresaServicioPrevencion = new EmpresaServicioPrevencion();
		empresaServicioPrevencion.setCodprev080(codprev080);
		empresaServicioPrevencion = this.empresaServicioPrevencionService
				.find(empresaServicioPrevencion);
		EmpresaServicioPrevencionController.logger
				.info("[GET - findBy_PK] : Obtener Ab0480s00 por PK");
		return empresaServicioPrevencion;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *
	 * @param filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *  List<Ab0480s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<EmpresaServicioPrevencion> getAll(
			@ModelAttribute EmpresaServicioPrevencion filterEmpresaServicioPrevencion) {
		EmpresaServicioPrevencionController.logger.info(
				"[GET - find_ALL] : Obtener EmpresaServicioPrevencion por filtro");
		return this.empresaServicioPrevencionService
				.findAll(filterEmpresaServicioPrevencion, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  empresaServicioPrevencion the empresa servicio prevencion
	 *
	 * @param empresaServicioPrevencion the empresa servicio prevencion
	 *  Ab0480s00 Bean resultante de la modificacion.
	 * @return the empresa servicio prevencion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody EmpresaServicioPrevencion edit(
			@RequestBody EmpresaServicioPrevencion empresaServicioPrevencion) {
		EmpresaServicioPrevencion empresaServicioPrevencionAux = this.empresaServicioPrevencionService
				.update(empresaServicioPrevencion);
		EmpresaServicioPrevencionController.logger.info(
				"[PUT] : EmpresaServicioPrevencion actualizado correctamente");
		return empresaServicioPrevencionAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  empresaServicioPrevencion the empresa servicio prevencion
	 *
	 * @param empresaServicioPrevencion the empresa servicio prevencion
	 *  Ab0480s00 Bean resultante del proceso de creacion.
	 * @return the empresa servicio prevencion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EmpresaServicioPrevencion add(
			@RequestBody EmpresaServicioPrevencion empresaServicioPrevencion) {
		EmpresaServicioPrevencion empresaServicioPrevencionAux = this.empresaServicioPrevencionService
				.add(empresaServicioPrevencion);
		EmpresaServicioPrevencionController.logger.info(
				"[POST] : EmpresaServicioPrevencion insertado correctamente");
		return empresaServicioPrevencionAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  codprev080
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param codprev080 the codprev 080
	 *  EmpresaServicioPrevencion Bean eliminado.
	 * @return the empresa servicio prevencion
	 */
	@RequestMapping(value = "/{codprev080}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody EmpresaServicioPrevencion remove(
			@PathVariable String codprev080) {
		EmpresaServicioPrevencion empresaServicioPrevencion = new EmpresaServicioPrevencion();
		empresaServicioPrevencion.setCodprev080(codprev080);
		this.empresaServicioPrevencionService.remove(empresaServicioPrevencion);
		EmpresaServicioPrevencionController.logger.info(
				"[DELETE] : EmpresaServicioPrevencion borrado correctamente");
		return empresaServicioPrevencion;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		EmpresaServicioPrevencionController.logger
				.info("[GET - View] : EmpresaServicioPrevencion");
		return "empresaservicioprevencion";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<Ab0480s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<EmpresaServicioPrevencion> filter(
			@RequestJsonBody(param = "filter") EmpresaServicioPrevencion filterEmpresaServicioPrevencion,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaServicioPrevencionController.logger
				.info("[POST - filter] : Obtener EmpresaServicioPrevencion");
		return this.empresaServicioPrevencionService.filter(
				filterEmpresaServicioPrevencion, jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *  searchEmpresaServicioPrevencion the search empresa servicio prevencion
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 * @param searchEmpresaServicioPrevencion the search empresa servicio prevencion
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Ab0480s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<EmpresaServicioPrevencion>> search(
			@RequestJsonBody(param = "filter") EmpresaServicioPrevencion filterEmpresaServicioPrevencion,
			@RequestJsonBody(param = "search") EmpresaServicioPrevencion searchEmpresaServicioPrevencion,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaServicioPrevencionController.logger
				.info("[POST - search] : Buscar EmpresaServicioPrevencion");
		return this.empresaServicioPrevencionService.search(
				filterEmpresaServicioPrevencion,
				searchEmpresaServicioPrevencion, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") EmpresaServicioPrevencion filterEmpresaServicioPrevencion,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaServicioPrevencionController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples EmpresaServicioPrevencion");
		this.empresaServicioPrevencionService.removeMultiple(
				filterEmpresaServicioPrevencion, jqGridRequestDto, false);
		EmpresaServicioPrevencionController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterEmpresaServicioPrevencion the filter empresa servicio prevencion
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() EmpresaServicioPrevencion filterEmpresaServicioPrevencion,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<EmpresaServicioPrevencion> listEmpresaServicioPrevencion = this.empresaServicioPrevencionService
				.findAllLike(filterEmpresaServicioPrevencion, jqGridRequestDto,
						false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.servicioPrevencion"),
				columns, listEmpresaServicioPrevencion);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}
}
